import config from "dotenv";

config.config();

export default {
  bufferSize: 24, // number of images to buffer
  maxBatchPull: 2, // number of calendars to pull and prepocess at a time
  bufferLoopSleep: 5000, // sleep time in milliseconds
  maxJobSize: 12, // number of images to process at a time
  jobLoopSleep: 1000, // sleep time in milliseconds
  outputFormat: "png",
  uploadLoopSleep: 5000, // sleep time in milliseconds
  deleteTimeout: 1000 * 60, // timeout in milliseconds to delete the image after it is uploaded
  espoStatusUpdateLoopSleep: 1000, // sleep time in milliseconds for the espo status update loop
  facefusion: {
    condaEnv: "facefusion",
    pythonBin: "python",
    path: "/facefusion",
    args: "job-run-all --execution-providers cuda --execution-queue-count 3",
  },
  aws: {
    region: process.env.AWS_REGION || "ap-south-1",
    accessKeyId: process.env.AWS_ACCESS_KEY_ID || "",
    secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY || "",
    queueUrl:
      process.env.AWS_QUEUE_URL ||
      "https://sqs.ap-south-1.amazonaws.com/307382678545/face-swap-prod",
  },
  espo: {
    key: process.env.ESPO_KEY || "",
  },
  cache: {
    maxSize: 1024 * 1024 * 1024 * 100, // 100GB
  },
  assetsMapping: {
    localCacheDir: "./assets",
    dockerAssetsDir: "/assets",
  },
  outputDir: "./output", // relative to facefusion.path
  preprocessing: {
    maxSideLength: 1000, // in px
  },
};
