import config from "dotenv";

config.config();

export default {
  bufferSize: 10, // number of images to buffer
  maxBatchPull: 2, // number of calendars to pull and prepocess at a time
  bufferLoopSleep: 1000, // sleep time in milliseconds
  maxJobSize: 4, // number of images to process at a time
  jobLoopSleep: 1000, // sleep time in milliseconds
  outputFormat: "png",
  uploadLoopSleep: 1000, // sleep time in milliseconds
  deleteTimeout: 1000 * 60, // timeout in milliseconds to delete the image after it is uploaded
  espoStatusUpdateLoopSleep: 1000, // sleep time in milliseconds for the espo status update loop
  facefusion: {
    condaEnv: "facefusion",
    pythonBin: "/home/aac/anaconda3/envs/facefusion/bin/python",
    path: "/home/aac/dev/pixika-calendar/face-swap/facefusion",
    args: "job-run-all --execution-queue-count 1",
  },
  aws: {
    region: process.env.AWS_REGION || "ap-south-1",
    accessKeyId: process.env.AWS_ACCESS_KEY_ID || "",
    secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY || "",
    queueUrl:
      process.env.AWS_QUEUE_URL ||
      "https://sqs.ap-south-1.amazonaws.com/307382678545/face-swap-dummy-dev",
  },
  espo: {
    key: process.env.ESPO_KEY || "",
  },
  cache: {
    maxSize: 1024 * 1024 * 1024, // 1GB
  },
  assetsMapping: {
    localCacheDir: "./assets",
    dockerAssetsDir: "/assets",
  },
  outputDir: "./output", // relative to facefusion.path
  preprocessing: {
    maxSideLength: 1000, // in px
  },
};
