import config from "../config.ts";
import { SQSClient, SendMessageCommand } from "@aws-sdk/client-sqs";

/**
 * Uploads a string payload to an AWS SQS queue using configuration from config.ts.
 *
 * @param payload - The string payload to be uploaded.
 * @returns A promise that resolves when the message is sent.
 */
export async function uploadStringToSqs(payload: string): Promise<void> {
  try {
    // Configure the SQS client with credentials and region from config.
    const client = new SQSClient({
      region: config.aws.region,
      credentials: {
        accessKeyId: config.aws.accessKeyId,
        secretAccessKey: config.aws.secretAccessKey,
      },
    });

    // Create the command to send a message.
    const command = new SendMessageCommand({
      QueueUrl: config.aws.queueUrl,
      MessageBody: payload,
    });

    // Send the message to the queue.
    const response = await client.send(command);

    console.log("Successfully sent message to SQS.");
    console.log("Message ID:", response.MessageId);
  } catch (error) {
    console.error("Error uploading message to SQS:", error);
  }
}

const calendarIds = Array(100).fill("68c2b3607bf4ce4bc");

for (const calendarId of calendarIds) {
  uploadStringToSqs(calendarId);
}
