import cv2
from facefusion import state_manager

from facefusion.types import VideoPoolSet

VIDEO_POOL_SET: VideoPoolSet = {}


def get_video_capture(video_path: str) -> cv2.VideoCapture:
    if video_path not in VIDEO_POOL_SET:
        VIDEO_POOL_SET[video_path] = cv2.VideoCapture(video_path)

    return VIDEO_POOL_SET.get(video_path)


def clear_video_pool() -> None:
    # In tolerant strategy, keep video handles to avoid re-opening and reduce idle time
    if state_manager.get_item('video_memory_strategy') == 'tolerant':
        return
    for video_capture in VIDEO_POOL_SET.values():
        video_capture.release()

    VIDEO_POOL_SET.clear()
