// State variables extracted from service files

// Buffering service state
export const buffer: {
  calendarId: string;
  sourceURL: string;
  targetURL: string;
}[] = []; // list of calendar ids in buffer

export const resultURLCalendarIdMap: Map<string, string> = new Map(); // maps resultURL to corresponding calendar id

export const detailsMap: Map<string, any> = new Map(); // map of calendar ids to details

export const calendarIdCountMap: Map<string, number> = new Map(); // map of calendar ids to total count of images to be processed for that calendar

export const calendarSQSMap: Map<string, string> = new Map(); // map of calendar ids to sqs messages

export const calendarNumProcessed: Map<string, Set<string>> = new Map(); // map of calendar ids to array of image result urls processed

// Processing service state
export const uuidURLMap: Map<string, string> = new Map();

// Assets service state
export const cacheMap = new Map<string, string>(); // maps url to full path of the file

export const lruMap = new Map<string, number>(); // maps url to last used time

// set of image ids (S3 URLs) that have been completed
export const completedImageURLs: Set<string> = new Set();

// Upload service state
export const submittedCalendarIds: Set<string> = new Set(); // set of calendar ids that have been completed

export const ongoingUploads: string[] = []; // urls that are currently being uploaded

// espo service state
export const EspoStatusUpdateQueue: {
  calendarId: string;
  status: "IN-PROGRESS" | "DONE" | "FAILED";
}[] = [];
